/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.util;

import com.ibm.hwmca.fw.util.NativeProcess;
import com.ibm.hwmca.fw.util.NativeProcessParameters;
import com.ibm.hwmca.fw.util.Trace;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public class RsfExecUtils {
    private static String TRACE_MASKT = "XRSFEX T";
    private static String TRACE_MASKF = "XRSFEX F";
    private static String TRACE_MASKD = "XRSFEX D";
    public static final String REMOTE_EXEC_PARM_TYPE_ERROR = "Remote execute parameter type error";
    public static final String REMOTE_EXEC_NUM_PARM_ERROR = "Remote execute number of parameters error";
    public static final String REMOTE_EXEC_EXECUTE_ERROR = "Remote execute error ";
    public static final String REMOTE_EXEC_EXECUTE_ERROR_RC = "Remote execute error. Rc=";
    public static final String REMOTE_EXEC_SUCCESS_VOID_RETURN = "Remote execute void result";
    public static final String REMOTE_EXEC_RC = "Remote execute rc: ";
    public static final String REMOTE_EXEC_SUCCESSFUL = "Successful remote execute";
    public static final String REMOTE_EXEC_PROGRAM_NAME_ERROR = "Program name unspecified or incorrect";

    public static Object processExecute(Object arg) {
        String[] parms;
        Trace.trace(TRACE_MASKT, "-> RsfExecUtils::processExecute()");
        try {
            parms = (String[])arg;
        }
        catch (Exception e) {
            return REMOTE_EXEC_PARM_TYPE_ERROR;
        }
        if (parms == null || parms.length < 1) {
            return REMOTE_EXEC_NUM_PARM_ERROR;
        }
        try {
            NativeProcess np = NativeProcess.exec(new NativeProcessParameters(parms));
            Trace.trace(TRACE_MASKD, "RsfExecUtils.processExecute: waiting");
            np.waitFor();
            Trace.trace(TRACE_MASKF, "RsfExecUtils.processExecute: done waitng");
            int rc = np.exitValue();
            Trace.trace(TRACE_MASKF, "RsfExecUtils.processExecute: rc=" + rc);
            return REMOTE_EXEC_RC + rc;
        }
        catch (Exception e) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            e.printStackTrace(new PrintStream(baos));
            Trace.trace(TRACE_MASKT, "<- RsfExecUtils::processExecute()");
            return "Remote execute error  " + baos.toString();
        }
    }
}

